"""
This demo shows you how to use animated GIF files in a traits user interface.
"""

from os.path \
    import abspath, join, dirname
    
from enthought.traits.api \
    import HasTraits, File, Bool, Int
    
from enthought.traits.ui.api \
    import View, VGroup, HGroup, Item, EnumEditor
    
from enthought.traits.ui.wx.animated_gif_editor \
    import AnimatedGIFEditor

base_path = join( abspath( dirname( __file__ ) ), 'images' )

files = [
    join( base_path, 'logo_64x64.gif' ),
    join( base_path, 'logo_48x48.gif' ),
    join( base_path, 'logo_32x32.gif' )
]

class AnimatedGIFDemo ( HasTraits ):
    
    # The animated GIF file to display:
    gif_file = File( files[0] )
                 
    # Is the animation playing or not?
    playing = Bool( True )
    
    # The current frame to display (<0 means run the animation continuously):
    frame = Int( -1 )
                 
    # The traits view:
    view = View(
               VGroup(
                   HGroup(
                       Item( 'gif_file', 
                             editor     = AnimatedGIFEditor( playing = 'playing' ),
                             show_label = False ),
                       Item( 'playing' ),
                   ),
                   '_',
                   Item( 'gif_file', 
                         label  = 'GIF File',
                         editor = EnumEditor( values = files )
                   )
               ),
               title   = 'Animated GIF Demo',
               buttons = [ 'OK' ]
           )
                                    
demo = AnimatedGIFDemo()

if __name__ == '__main__':
    demo.configure_traits()
